/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;

public final class FSA5
extends FSA {
    public static final byte DEFAULT_FILLER = 95;
    public static final byte DEFAULT_ANNOTATION = 43;
    public static final byte VERSION = 5;
    public static final int BIT_FINAL_ARC = 1;
    public static final int BIT_LAST_ARC = 2;
    public static final int BIT_TARGET_NEXT = 4;
    public static final int ADDRESS_OFFSET = 1;
    public final byte[] arcs;
    public final int nodeDataLength;
    private Set<FSAFlags> flags;
    public final int gtl;
    public final byte filler;
    public final byte annotation;

    FSA5(InputStream stream) throws IOException {
        DataInputStream in = new DataInputStream(stream);
        this.filler = in.readByte();
        this.annotation = in.readByte();
        byte hgtl = in.readByte();
        this.flags = EnumSet.of(FSAFlags.FLEXIBLE, FSAFlags.STOPBIT, FSAFlags.NEXTBIT);
        if ((hgtl & 0xF0) != 0) {
            this.flags.add(FSAFlags.NUMBERS);
        }
        this.flags = Collections.unmodifiableSet(this.flags);
        this.nodeDataLength = hgtl >>> 4 & 0xF;
        this.gtl = hgtl & 0xF;
        this.arcs = FSA5.readRemaining(in);
    }

    @Override
    public int getRootNode() {
        int epsilonNode = this.skipArc(this.getFirstArc(0));
        return this.getDestinationNodeOffset(this.getFirstArc(epsilonNode));
    }

    @Override
    public final int getFirstArc(int node) {
        return this.nodeDataLength + node;
    }

    @Override
    public final int getNextArc(int arc) {
        if (this.isArcLast(arc)) {
            return 0;
        }
        return this.skipArc(arc);
    }

    @Override
    public int getArc(int node, byte label) {
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (this.getArcLabel(arc) == label) {
                return arc;
            }
            arc = this.getNextArc(arc);
        }
        return 0;
    }

    @Override
    public int getEndNode(int arc) {
        int nodeOffset = this.getDestinationNodeOffset(arc);
        assert (nodeOffset != 0) : "No target node for terminal arcs.";
        return nodeOffset;
    }

    @Override
    public byte getArcLabel(int arc) {
        return this.arcs[arc];
    }

    @Override
    public boolean isArcFinal(int arc) {
        return (this.arcs[arc + 1] & 1) != 0;
    }

    @Override
    public boolean isArcTerminal(int arc) {
        return 0 == this.getDestinationNodeOffset(arc);
    }

    @Override
    public int getRightLanguageCount(int node) {
        assert (this.getFlags().contains((Object)FSAFlags.NUMBERS)) : "This FSA was not compiled with NUMBERS.";
        return FSA5.decodeFromBytes(this.arcs, node, this.nodeDataLength);
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return this.flags;
    }

    public boolean isArcLast(int arc) {
        return (this.arcs[arc + 1] & 2) != 0;
    }

    public boolean isNextSet(int arc) {
        return (this.arcs[arc + 1] & 4) != 0;
    }

    static final int decodeFromBytes(byte[] arcs, int start2, int n) {
        int r = 0;
        int i = n;
        while (--i >= 0) {
            r = r << 8 | arcs[start2 + i] & 0xFF;
        }
        return r;
    }

    final int getDestinationNodeOffset(int arc) {
        if (this.isNextSet(arc)) {
            return this.skipArc(arc);
        }
        return FSA5.decodeFromBytes(this.arcs, arc + 1, this.gtl) >>> 3;
    }

    private int skipArc(int offset) {
        return offset + (this.isNextSet(offset) ? 2 : 1 + this.gtl);
    }
}

